/****** Object:  StoredProcedure [dbo].[P_PG_CRED_GERAR_DUPLICATA_COMPRAS]    Script Date: 02/06/2014 15:48:52 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_PG_CRED_GERAR_DUPLICATA_COMPRAS]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_PG_CRED_GERAR_DUPLICATA_COMPRAS]
GO
GO

--P_PG_CRED_GERAR_DUPLICATA_COMPRAS 154,2014
CREATE PROCEDURE [dbo].[P_PG_CRED_GERAR_DUPLICATA_COMPRAS](@CD_FILIAL AS INT, @ANO INT=0 )
AS
IF  OBJECT_ID('TEMPDB.DBO.#TBL_CRED') IS NOT NULL
BEGIN
	 DROP TABLE #TBL_CRED
END


DECLARE @NR_DP INT; 
DECLARE @CD_CTR INT;

---------------------------------------------------------------------------------------------------------------------
--	CARREGA A NUMERAO DE DUPLICATAS
---------------------------------------------------------------------------------------------------------------------

SET @NR_DP = ISNULL((SELECT 
						 MAX(NR_DP) NR_DP_ULT 
					FROM
						PG_CRED
					where
						ANO = @ANO
						AND CD_EMP=1
						AND CD_FILIAL =@CD_FILIAL),right(@ano * 1000000,len(@ano * 1000000)-2))

	
SET @CD_CTR = ISNULL((SELECT 
						 MAX(CD_PG_CRED) CD_PG_CRED 
					FROM
						PG_CRED
					where
						CD_EMP=1
						AND CD_FILIAL =@CD_FILIAL),0)
	
	
---------------------------------------------------------------------------------------------------------------------
--	CRIA A TABELA TEMPORARIA DE DUPLICATAS
---------------------------------------------------------------------------------------------------------------------
SELECT 
	E.CD_EMP,
	E.CD_FILIAL,
	ROW_NUMBER() OVER ( PARTITION BY E.CD_FILIAL ORDER BY E.CD_FILIAL) + @CD_CTR CD_PG_CRED,
	E.CD_FORN,
	E.CD_NF,
	E.DT_EMI_NF,
	E.NR_NF,
	E.VLR_NF AS VLR_DP,
	1 AS PARC,
	E.DT_ENT + 30 AS DT_VENCTO ,
	GETDATE() DT_CAD,
	ROW_NUMBER() OVER ( PARTITION BY E.CD_FILIAL ORDER BY E.CD_FILIAL) + @NR_DP NR_DP,
	0 COB,
	E.VLR_NF AS SLD_DP,
	1 CD_BC,
	1 CD_USU,
	E.VLR_NF,
	@ANO ANO,
	0 AS VLR_DESC,
	CONVERT(VARCHAR,E.NR_NF ) + '-' + CONVERT(VARCHAR(4),YEAR(E.DT_ENT)) +'-' + '0' + CONVERT(VARCHAR,1) NR_TIT , --='1690747-2013-01'
	0 ORIG_LANC,
	E.DT_ENT DT_EMIS,
	7 CD_HIST,
	0 VLR_DESP_OUTR,
	0 VLR_DEVOLUCAO,
	0 VLR_JUROS,
	0 TP_DP  
	INTO #TBL_CRED
FROM 
	V_EST_NF_ENT_CAB  E
	LEFT JOIN PG_CRED_EST_NF_ENT P ON 
	E.CD_EMP	= P.CD_EMP AND
	E.CD_NF		= P.CD_NF AND
	E.CD_FILIAL = P.CD_FILIAL  
	  
	LEFT OUTER JOIN  EST_NF_ENT_EST_NF_SAI_TRANSF T ON 
	E.CD_EMP	= T.CD_EMP AND
	E.CD_NF		= T.CD_NF_ENT AND
	E.CD_FILIAL = T.CD_FIL_DEST 
WHERE
	E.CD_EMP=1
	AND P.CD_EMP IS NULL
	AND E.CD_FILIAL =@CD_FILIAL
	AND YEAR(E.DT_ENT) =@ANO
	AND T.CD_NF_ENT  IS NULL
	AND E.IGNORAR_GERACAO_FINAN=0 
	AND E.TP_MOV_OP_TRANSA=0
	AND E.GERA_DP_PG=1
 
---------------------------------------------------------------------------------------------------------------------
--	INSERE OS REGISTROS NA PG_CRED_DUP_NR_CTR
---------------------------------------------------------------------------------------------------------------------

INSERT INTO PG_CRED_DUP_NR_CTR (CD_EMP,CD_FILIAL, NR_DP,  ANO, TP_DOC)
SELECT DISTINCT
	CD_EMP, 
	CD_FILIAL, 
	NR_DP, 
	ANO,
	TP_DP 
FROM  #TBL_CRED

---------------------------------------------------------------------------------------------------------------------
--	INSERE OS REGISTROS NA PG_CRED
---------------------------------------------------------------------------------------------------------------------
INSERT INTO PG_CRED (CD_EMP,CD_FILIAL,CD_PG_CRED,CD_FORN,VLR_DP,PARC,DT_VENCTO,
	DT_CAD,NR_DP,COB,SLD_DP,CD_BC,CD_USU,VLR_NF,ANO,VLR_DESC,
	NR_TIT,ORIG_LANC,DT_EMIS,CD_HIST,VLR_DESP_OUTR,VLR_DEVOLUCAO,
	VLR_JUROS,TP_DP) 
SELECT	
	CD_EMP,
	CD_FILIAL,
	CD_PG_CRED,
	CD_FORN,
	VLR_DP,
	PARC,
	DT_VENCTO,
	DT_CAD,
	NR_DP,
	COB,
	SLD_DP,
	CD_BC,
	CD_USU,
	VLR_NF,
	ANO,
	VLR_DESC,
	NR_TIT,
	ORIG_LANC,
	DT_EMIS,
	CD_HIST,
	VLR_DESP_OUTR,
	VLR_DEVOLUCAO,
	VLR_JUROS,
	TP_DP
FROM  
	#TBL_CRED
 
---------------------------------------------------------------------------------------------------------------------
--	INSERE OS REGISTROS NA PG_CRED_EST_NF_ENT
---------------------------------------------------------------------------------------------------------------------
 
INSERT INTO PG_CRED_EST_NF_ENT (CD_EMP,CD_FILIAL,NR_DP,ANO,CD_NF)
SELECT DISTINCT
	CD_EMP,
	CD_FILIAL,
	NR_DP,
	ANO,
	CD_NF
FROM  
	#TBL_CRED 

---------------------------------------------------------------------------------------------------------------------
--	INSERE OS REGISTROS NA PG_CRED_NF
---------------------------------------------------------------------------------------------------------------------

INSERT INTO PG_CRED_NF (CD_EMP,	CD_FILIAL,NR_DP,ANO,NR_NF,DT_EMI_NF,VLR_NF)
SELECT DISTINCT
	CD_EMP,
	CD_FILIAL,
	NR_DP,
	ANO,
	NR_NF,
	DT_EMI_NF,
	VLR_NF
FROM  
	#TBL_CRED